﻿var questionnaireChanges = {
    context: $(".v-questionnaireChanges"),
    questionnaireId: 0,
    questionnaireName: "",
    datatable: null,
    initializeDataTable: function () {
        this.datatable = $(".h-questionnaireChangesTable", this.context).a4datatable({
            displayLength: 20,
            height: "full",
            ajaxAction: a4.getAction("GetQuestionnaireChanges", "Home", "Project"),
            ajaxParams: { questionnaireId: questionnaireChanges.questionnaireId },
            quickFilter: {
                "Items": [
                    { "Label": resources.Pending, "AjaxParams": { "status": 0 } },
                    { "Label": resources.Applied, "AjaxParams": { "status": 1 } },
                    { "Label": resources.Rejected, "AjaxParams": { "status": 2 } }
                ]
            },
            columns: [
                { "Data": "ParametersLabel", "Tooltip": true },
                { "Title": resources.Id, "Data": "Id" },
                { "Title": resources.Alias, "Data": "Alias" },
                { "Title": resources.Status, "Data": "StatusEnum", "Name": "Status" },
                { "Title": resources.ModifiedBy, "Data": "UserName", "Name": "UserName" },
                { "Title": resources.ModifiedOn, "Data": "ChangeDate", "Type": "datetime" },
                { "Title": resources.Action, "Data": "ActionEnum", "Name": "Action" }
            ],
            localizableTexts: { "All": resources.AllChanges, "Search": resources.SearchChanges },
            defaultSorting: { Column: "Id", Ascending: false },
            allowRowSelection: "([Status] == 0 || [Status]==2) && (voxco.security.has('COMMIT_PENDINGTRANSACTION') || voxco.security.has('DELETE_PENDINGTRANSACTION'))",
            toolBarItems: [
                { "Action": "commit", "Label": resources.Apply, "DisplayCondition": function (data) { return data.Status == 0; }, "Visible": voxco.security.has('COMMIT_PENDINGTRANSACTION') },
                { "Action": "discard", "Label": resources.Reject, "DisplayCondition": function (data) { return data.Status == 0; }, "Visible": voxco.security.has('DELETE_PENDINGTRANSACTION') },
                { "Action": "undiscard", "Label": resources.Recycle, "DisplayCondition": function (data) { return data.Status == 2 && data.Action != 7; }, "Visible": voxco.security.has('DELETE_PENDINGTRANSACTION') }
            ],
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.pluck(rows, "Id");

                switch (action) {
                    case "commit":
                        questionnaireChanges.commitChanges(ids);
                        break;
                    case "discard":
                        questionnaireChanges.discardChanges(ids);
                        break;
                    case "undiscard":
                        questionnaireChanges.undiscardChanges(ids);
                        break;
                }
            },
            contextMenuItems: [
                { "Action": "commit", "Label": resources.Apply, "DisplayCondition": function (data) { return data.Status == 0 && voxco.security.has('COMMIT_PENDINGTRANSACTION'); } },
                { "Action": "discard", "Label": resources.Reject, "DisplayCondition": function (data) { return data.Status == 0 && voxco.security.has('DELETE_PENDINGTRANSACTION'); } },
                { "Action": "undiscard", "Label": resources.Recycle, "DisplayCondition": function (data) { return data.Status == 2 && voxco.security.has('DELETE_PENDINGTRANSACTION'); } }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "commit":
                        questionnaireChanges.commitChanges([row.Id]);
                        break;
                    case "discard":
                        questionnaireChanges.discardChanges([row.Id]);
                        break;
                    case "undiscard":
                        questionnaireChanges.undiscardChanges([row.Id]);
                        break;
                }
            }
        });
    },
    commitChanges: function (ids) {
        questionnaireChanges.callServerMethod("CommitQuestionnaireChanges", confirmCommitChangesResources, ids);
    },
    discardChanges: function (ids) {
        questionnaireChanges.callServerMethod("DiscardQuestionnaireChanges", confirmDiscardChangesResources, ids);
    },
    undiscardChanges: function (ids) {        
        a4.callServerMethod(a4.getAction("UndiscardQuestionnaireChanges", "Home", "Project"), { questionnaireId: questionnaireChanges.questionnaireId, changeIds: ids },
        function (result) {
            questionnaireChanges.datatable.a4datatable("refresh");
        });
    },
    callServerMethod: function (method, resources, ids) {
        modalDialog.showConfirmDialog(resources, function () {
            a4.callServerMethod(a4.getAction(method, "Home", "Project"), { questionnaireId: questionnaireChanges.questionnaireId, changeIds: ids },
                function (result) {
                    questionnaireChanges.datatable.a4datatable("refresh");
                });
        }, 220, 500, false, { "count": ids.length, "name": questionnaireChanges.questionnaireName });
    }
}

$(document).ready(function () {
    if (questionnaireChanges.context.length > 0) {
        questionnaireChanges.questionnaireId = $("#QuestionnaireId", questionnaireChanges.context).val();
        questionnaireChanges.questionnaireName = $("#QuestionnaireName", questionnaireChanges.context).val();
        questionnaireChanges.initializeDataTable();
    }
});